<?php
// File: /admin/investments.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireAdmin();

$stmt = $pdo->query("
    SELECT i.*, u.username, p.name as plan_name 
    FROM investments i 
    JOIN users u ON i.user_id = u.id 
    JOIN investment_plans p ON i.plan_id = p.id 
    ORDER BY i.start_date DESC
");
$investments = $stmt->fetchAll();

$page_title = "All Investments";
include '../includes/header.php';
?>

<div class="card">
    <h3 class="mb-4">Investment History</h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>User</th>
                    <th>Plan</th>
                    <th>Amount</th>
                    <th>Start Date</th>
                    <th>End Date</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($investments as $inv): ?>
                <tr>
                    <td>#<?php echo $inv['id']; ?></td>
                    <td><?php echo htmlspecialchars($inv['username']); ?></td>
                    <td><?php echo htmlspecialchars($inv['plan_name']); ?></td>
                    <td><?php echo formatMoney($inv['amount']); ?></td>
                    <td><?php echo date('M d, Y', strtotime($inv['start_date'])); ?></td>
                    <td><?php echo date('M d, Y', strtotime($inv['end_date'])); ?></td>
                    <td>
                        <span class="badge badge-<?php echo $inv['status'] == 'active' ? 'success' : 'secondary'; ?>">
                            <?php echo ucfirst($inv['status']); ?>
                        </span>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
