<?php
// File: /admin/users.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireAdmin();

// Handle Balance Update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_balance'])) {
    $user_id = $_POST['user_id'];
    $amount = $_POST['amount'];
    
    $stmt = $pdo->prepare("UPDATE users SET balance = ? WHERE id = ?");
    $stmt->execute([$amount, $user_id]);
    setFlash('success', 'User balance updated.');
    redirect('users.php');
}

// Fetch Users
$stmt = $pdo->query("SELECT * FROM users WHERE role = 'user' ORDER BY created_at DESC");
$users = $stmt->fetchAll();

$page_title = "Manage Users";
include '../includes/header.php';
?>

<div class="card">
    <h3 class="mb-4">Registered Users</h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Username</th>
                    <th>Email</th>
                    <th>Balance</th>
                    <th>Joined</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $u): ?>
                <tr>
                    <td>#<?php echo $u['id']; ?></td>
                    <td><?php echo htmlspecialchars($u['username']); ?></td>
                    <td><?php echo htmlspecialchars($u['email']); ?></td>
                    <td><?php echo formatMoney($u['balance']); ?></td>
                    <td><?php echo date('M d, Y', strtotime($u['created_at'])); ?></td>
                    <td>
                        <form method="POST" class="d-flex" style="display:flex; gap:10px;">
                            <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
                            <input type="number" name="amount" value="<?php echo $u['balance']; ?>" step="0.01" class="form-control" style="width: 100px; padding: 5px;">
                            <button type="submit" name="update_balance" class="btn btn-primary" style="padding: 5px 10px; font-size: 0.8rem;">Update</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
