<?php
// File: /public/dashboard.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireLogin();

$user = getCurrentUser($pdo);
$user_id = $user['id'];

// Fetch Stats
// 1. Total Active Investments
$stmt = $pdo->prepare("SELECT SUM(amount) as total FROM investments WHERE user_id = ? AND status = 'active'");
$stmt->execute([$user_id]);
$active_investment = $stmt->fetch()['total'] ?? 0;

// 2. Total Profit (from transactions or investments table)
// We'll use transactions for accuracy if we log profits there
$stmt = $pdo->prepare("SELECT SUM(amount) as total FROM transactions WHERE user_id = ? AND type = 'profit'");
$stmt->execute([$user_id]);
$total_profit = $stmt->fetch()['total'] ?? 0;

// 3. Recent Transactions
$stmt = $pdo->prepare("SELECT * FROM transactions WHERE user_id = ? ORDER BY created_at DESC LIMIT 5");
$stmt->execute([$user_id]);
$recent_transactions = $stmt->fetchAll();

$page_title = "Dashboard";
include '../includes/header.php';
?>

<!-- Stats Grid -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-title">Total Balance</div>
        <div class="stat-value text-primary"><?php echo formatMoney($user['balance']); ?></div>
        <div class="text-muted text-sm mt-2">Available for withdrawal</div>
    </div>
    <div class="stat-card">
        <div class="stat-title">Active Investment</div>
        <div class="stat-value text-success"><?php echo formatMoney($active_investment); ?></div>
        <div class="text-muted text-sm mt-2">Currently growing</div>
    </div>
    <div class="stat-card">
        <div class="stat-title">Total Profit</div>
        <div class="stat-value text-warning" style="color: #f59e0b;"><?php echo formatMoney($total_profit); ?></div>
        <div class="text-muted text-sm mt-2">All time earnings</div>
    </div>
</div>

<!-- Chart Section -->
<div class="card">
    <h3 class="mb-4">Portfolio Growth</h3>
    <div style="position: relative; height: 300px; width: 100%;">
        <canvas id="investmentChart"></canvas>
    </div>
</div>

<!-- Recent Transactions -->
<div class="card mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>Recent Transactions</h3>
        <a href="transactions.php" class="text-primary">View All</a>
    </div>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($recent_transactions) > 0): ?>
                    <?php foreach ($recent_transactions as $tx): ?>
                        <tr>
                            <td><?php echo date('M d, Y', strtotime($tx['created_at'])); ?></td>
                            <td>
                                <span class="badge badge-<?php 
                                    echo $tx['type'] == 'deposit' ? 'success' : 
                                        ($tx['type'] == 'withdrawal' ? 'danger' : 'primary'); 
                                ?>">
                                    <?php echo ucfirst($tx['type']); ?>
                                </span>
                            </td>
                            <td class="<?php echo $tx['type'] == 'deposit' || $tx['type'] == 'profit' ? 'text-success' : 'text-danger'; ?>">
                                <?php echo ($tx['type'] == 'deposit' || $tx['type'] == 'profit' ? '+' : '-') . formatMoney($tx['amount']); ?>
                            </td>
                            <td>Completed</td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted">No transactions found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
