<?php
// File: /public/deposit.php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

requireLogin();
$user = getCurrentUser($pdo);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = $_POST['amount'];
    $method = clean($_POST['method']);
    $tx_id = clean($_POST['transaction_id']);

    if ($amount <= 0) {
        setFlash('danger', 'Invalid amount.');
    } elseif (empty($tx_id)) {
        setFlash('danger', 'Transaction ID is required.');
    } else {
        try {
            // Create deposit request
            $stmt = $pdo->prepare("INSERT INTO deposits (user_id, amount, method, transaction_id, status) VALUES (?, ?, ?, ?, 'pending')");
            $stmt->execute([$user['id'], $amount, $method, $tx_id]);

            // Log transaction (status pending)
            logTransaction($pdo, $user['id'], 'deposit', $amount, "Deposit Request ($method) - Pending");

            setFlash('success', 'Deposit request submitted. Waiting for approval.');
            redirect('transactions.php');

        } catch (Exception $e) {
            setFlash('danger', 'Error: ' . $e->getMessage());
        }
    }
}

$page_title = "Deposit Funds";
include '../includes/header.php';
?>

<div class="card" style="max-width: 600px; margin: 0 auto;">
    <h3 class="mb-4">Add Funds</h3>
    <p class="text-muted mb-4">Send payment to the wallet below and submit the transaction ID.</p>
    
    <div class="alert alert-secondary text-center">
        <strong>USDT (TRC20) Address:</strong><br>
        <code style="font-size: 1.1rem; color: var(--accent-blue);">T9yD14Nj9j7xAB4dbGeKsqWW8F9m4HGxp5</code>
    </div>

    <form method="POST" action="">
        <div class="form-group">
            <label>Amount (USD)</label>
            <input type="number" name="amount" class="form-control" step="0.01" required>
        </div>
        <div class="form-group">
            <label>Payment Method</label>
            <select name="method" class="form-control">
                <option value="USDT">USDT</option>
                <option value="Bitcoin">Bitcoin</option>
                <option value="Ethereum">Ethereum</option>
            </select>
        </div>
        <div class="form-group">
            <label>Transaction Hash / ID</label>
            <input type="text" name="transaction_id" class="form-control" placeholder="Paste transaction ID here" required>
        </div>
        <button type="submit" class="btn btn-success btn-block">Submit Payment</button>
    </form>
</div>

<?php include '../includes/footer.php'; ?>
